#include "include/AgtPCIEExerciser.h"
#include "include/AgtPortSelector.h"

#include <iostream>
using namespace std;

int main( int argc, char* argv[] )
{
  CAgtPortSelector *myPortSelector = NULL; // Connection handling
  CAgtPCIEExerciser *myExerciser = NULL;   // Exerciser programming

  // Handle to device
  AgtPortHandleT myHandle = AGT_INVALID_PORTHANDLE;

  cout << "Starting main" << std::endl;

  try  // All error handling is done via exceptions of class CAgtException
  {
    // Create (the one and only) PortSelector instance.
    // This class provides functionality for
    // handling the connection to the PCIE driver.
    myPortSelector = new CAgtPortSelector;

    // Create (the one and only) Exerciser instance.
    // This class contains all 
    // functions for programming the exerciser.
    myExerciser    = new CAgtPCIEExerciser;
   
    UInt16 deviceId = AGT_INVALID_DEVID; // bus- (bits 15:8) slot- (7:4) and function (3:0) number
    
    // Get deviceId for first (parameter index=0) card found.
    // This looks for E2960 probeboards found on the PCIE bus.
    // To enumerate all cards in the system, you can call this function repeatedly with
    // index=0,1,2,3,... until the returned deviceId equals AGT_INVALID_DEVID.
    myPortSelector->DeviceIdGet( 0, &deviceId );
    if( deviceId == AGT_INVALID_DEVID )
    {
      cerr << "No board found, exiting." << endl;

      delete myExerciser;
      delete myPortSelector;

      return -1;
    }

    hex( cout );
    cout << "Found board at index 0 with devid 0x"  << deviceId << endl;

    // Open connection to found card
    myPortSelector->ConnectPort( deviceId, &myHandle );
    cout << "Connection established." << endl;

    // Do something with myHandle here
    UInt32 val = 0;
    myExerciser->ConfRegRead( myHandle, PCIE_HWCHANNEL_FUNCTION_A, 0, &val );
    cout << "Read " << val << " from configspace of function A" << endl;

    myExerciser->BlockGet( myHandle, PCIE_HWCHANNEL_FUNCTION_A, 0, PCIE_BLOCK_LEN, &val );
    cout << "Read " << val << " from block memory" << endl;
  }
  catch( CAgtException &e )
  {
    // API error
    cerr << e << endl;
  }
  catch( ... )
  {
    // catch all other errors here
  }

  // Close connection to card
  if( myPortSelector )
  {
    if( myHandle != AGT_INVALID_PORTHANDLE )
    {
      cout << "Closing connection." << std::endl;

      try
      {
        myPortSelector->DisconnectPort( myHandle );
        cout << "Connection closed." << endl;
      }
      catch( CAgtException &e )
      {
        // API error
        cerr << e << endl;
      }
    }
  }

  delete myExerciser;
  delete myPortSelector;

  return 0;
}